/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmt;

import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Format {
    private String m_name = "";
    private boolean m_local = true;
    private String m_fromIP = "";
    private Map<String, CmdValue> m_valueMap = new TreeMap<String, CmdValue>();
    private static final NamedValue[] g_avcsValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("NTSC M", 1), new NamedValue("NTSC 443", 2), new NamedValue("PAL BDGHI", 3), new NamedValue("PAL NC", 4), new NamedValue("PAL N", 5), new NamedValue("PAL M", 6), new NamedValue("PAL 60", 7)};
    private static final NamedValue[] g_asctValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("American ORed", 2), new NamedValue("American Single Serrated", 3), new NamedValue("American Double Serrated (ref SMPTE 170M NTSC)", 4), new NamedValue("Australian AS 493.1-200X CS serrated", 5), new NamedValue("European ORed", 6), new NamedValue("European Double Serrated (ref ITU-R BT.470-6 PAL)", 8), new NamedValue("SMPTE 296M-EIA/CEA", 9), new NamedValue("HDTV Single Serrated (ref SMPTE 296M)", 10), new NamedValue("SMPTE 295M-EIA/CEA", 11), new NamedValue("HDTV Double Serrated (ref SMPTE 295M)", 12), new NamedValue("SMPTE 274M-EIA/CEA", 14), new NamedValue("HDTV Double Serrated (ref SMPTE 240M, 260M, 274M)", 15)};
    private static final NamedValue[] g_dsctValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("American ORed", 2), new NamedValue("American Single Serrated", 3), new NamedValue("American Double Serrated (ref SMPTE 170M NTSC)", 4), new NamedValue("\"Australien\" AS 493.1-200X CS serrated", 5), new NamedValue("European ORed", 6), new NamedValue("European Double Serrated (ref ITU-R BT.470-6 PAL)", 8)};
    private static final NamedValue[] g_avstValues = new NamedValue[]{new NamedValue("Analog Grayscale YYY", 1), new NamedValue("Analog Component RGB", 2), new NamedValue("Analog Composite w/Color Kill", 3), new NamedValue("Analog Composite w/Subcarrier", 4), new NamedValue("Analog Component YPbPr SDTV", 6), new NamedValue("Analog Component YPbPr HDTV Legacy", 5), new NamedValue("Analog Component YPbPr HDTV Modern", 7), new NamedValue("Analog Component YPbPr Betacam", 11)};
    private static final NamedValue[] g_dvstValues = new NamedValue[]{new NamedValue("Digital Direct Monochrome", 1), new NamedValue("Digital Direct VI MDA", 2), new NamedValue("Digital Direct RGB", 5), new NamedValue("Digital Direct RGBI CGA", 6), new NamedValue("Digital Direct RrGgBb EGA", 7), new NamedValue("Digital Component YYY", 9), new NamedValue("Digital Component RGB", 10), new NamedValue("Digital Component YCbCr SDTV (ITU-R BT.601-5)", 13), new NamedValue("Digital Component YCbCr HDTV Legacy (SMPTE 240M)", 14), new NamedValue("Digital Component YCbCr HDTV Modern (ITU-R BT.709-5)", 15), new NamedValue("Digital BT.601 xvYCC", 17), new NamedValue("Digital BT.709 xvYCC", 18)};
    private static final NamedValue[] g_dsstValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("American Separate", 1), new NamedValue("European Separate", 5), new NamedValue("American HDTV Separate", 2), new NamedValue("European HDTV Separate", 3), new NamedValue("Japanese HDTV Separate", 4), new NamedValue("Australian AS 4933.1-200X HS & VS", 6), new NamedValue("IEC 62315-1 Australian AS 4933.1-200X HS+VS", 7)};
    private static final NamedValue[] g_ssstValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("DSS", 1), new NamedValue("DCS", 2), new NamedValue("DCS,DSS", 3), new NamedValue("ACS", 4), new NamedValue("ACS,DSS", 5), new NamedValue("ACS,DCS", 6), new NamedValue("ACS,DCS,DSS", 7), new NamedValue("DPMS OFF", 8), new NamedValue("DPMS Suspend", 9), new NamedValue("DPMS Stand-By", 10), new NamedValue("DPMS ON", 11)};
    private static final NamedValue[] g_peldValues = new NamedValue[]{new NamedValue("Default", 0), new NamedValue("8", 8), new NamedValue("24", 24)};
    private static final NamedValue[] g_dvsmValues = new NamedValue[]{new NamedValue("Default", 0), new NamedValue("4:2:2", 2), new NamedValue("4:4:4", 4)};
    private static final NamedValue[] g_dvptValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("DVI", 1), new NamedValue("HDMI", 2)};
    private static final NamedValue[] g_dasiValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("SPDIF", 1), new NamedValue("AES3", 2), new NamedValue("AES3id", 3), new NamedValue("Toslink Optical", 4), new NamedValue("MiniPlug Optical", 5)};
    private static final NamedValue[] g_dastValues = new NamedValue[]{new NamedValue("None", 0), new NamedValue("IEC 60958-3 Consumer LPCM", 1), new NamedValue("IEC 60958-4 Professional LPCM", 2), new NamedValue("IEC 61937 w/AC-3 (Dolby Digital)", 3), new NamedValue("MP2 (Video CD)", 6), new NamedValue("MP3 (MPEG1 Layer 3)", 5), new NamedValue("MPEG2 5.1 channel Advanced Audio Coding (AAC)", 7), new NamedValue("MPEG2 7.1 channel CBR or VBR", 8), new NamedValue("IEC 61937 w/DTS", 4), new NamedValue("ATRAC", 9)};
    private static final NamedValue[] g_nbcpValues = new NamedValue[]{new NamedValue("Default", 0), new NamedValue("6", 6), new NamedValue("8", 8), new NamedValue("10", 10), new NamedValue("12", 12)};
    private static final NamedValue[] g_nlnkValues = new NamedValue[]{new NamedValue("1", 1), new NamedValue("2", 2)};
    private static final NamedValue[] g_nbpaValues = new NamedValue[]{new NamedValue("Default", 0), new NamedValue("16", 16), new NamedValue("20", 20), new NamedValue("24", 24)};
    private static final NamedValue[] g_scanValues = new NamedValue[]{new NamedValue("Progressive", 1), new NamedValue("Interlace", 2)};
    private static final NamedValue[] g_usizeValues = new NamedValue[]{new NamedValue("inches", 1), new NamedValue("mm", 2)};
    private static final NamedValue[] g_avcmValues = new NamedValue[]{new NamedValue("Interpolate", 0), new NamedValue("Measure Interpolate", 1), new NamedValue("Measure Set Absolute", 2), new NamedValue("Test Levels", 3)};
    private static final NamedValue[] g_avcoValues = new NamedValue[]{new NamedValue("R-G-B", 0), new NamedValue("R-B-G", 1), new NamedValue("G-R-B", 2), new NamedValue("G-B-R", 3), new NamedValue("B-R-G", 4), new NamedValue("B-G-R", 5)};
    private static final CmdValue[] g_vals = new CmdValue[]{new CmdValue(CmdValueType.DOUBLE, "AVPS", 7.5, "Analog Video Pedestal Swing"), new CmdValue(CmdValueType.DOUBLE, "GAMA", 2.2, "Gamma Correction Factor"), new CmdValue(CmdValueType.DOUBLE, "AVSS", 0.7, "Analog Video Signal Swing"), new CmdValue(CmdValueType.DOUBLE, "ASSS", 0.3, "Analog Sync Signal Swing"), new CmdValue(CmdValueType.DOUBLE, "HSIZ", 11.2, "Horizontal Size"), new CmdValue(CmdValueType.DOUBLE, "VSIZ", 8.4, "Vertical Size"), new CmdValue(CmdValueType.DOUBLE, "HRAT", 31500.0, "Horizontal Rate (KHz)"), new CmdValue(CmdValueType.DOUBLE, "TUNE", 1.0, "Horizontal Tune Factor"), new CmdValue(CmdValueType.DOUBLE, "HRAT0", 31500.0, "Horizontal Base Rate"), new CmdValue(CmdValueType.DOUBLE, "ARAT", 48000.0, "Audio Sampling Rate"), new CmdValue(CmdValueType.DOUBLE, "DVSS", 1.0, "Digital Video Signal Swing #1"), new CmdValue("DVSS2", CmdValueType.DOUBLE, "OUT2:DVSS", 1.0, "Digital Video Signal Swing #2"), new CmdValue(CmdValueType.BOOL, "ASRG", 0.0, "Analog Sync Red Gate"), new CmdValue(CmdValueType.BOOL, "ASGG", 1.0, "Analog Sync Green Gate"), new CmdValue(CmdValueType.BOOL, "ASBG", 0.0, "Analog Sync Blue Gate"), new CmdValue(CmdValueType.BOOL, "HSPG", 1.0, "Horizontal Sync Pulse Gate"), new CmdValue(CmdValueType.BOOL, "VSPG", 1.0, "Vertical Sync Pulse Gate"), new CmdValue(CmdValueType.BOOL, "CSPG", 1.0, "Composite Sync Pulse Gate"), new CmdValue(CmdValueType.BOOL, "HSPP", 0.0, "Horizontal Sync Pulse Polarity"), new CmdValue(CmdValueType.BOOL, "VSPP", 0.0, "Vertical Sync Pulse Polarity"), new CmdValue(CmdValueType.BOOL, "CSPP", 0.0, "Composite Sync Pulse Polarity"), new CmdValue(CmdValueType.BOOL, "REDG", 1.0, "Red Gate"), new CmdValue(CmdValueType.BOOL, "GRNG", 1.0, "Green Gate"), new CmdValue(CmdValueType.BOOL, "BLUG", 1.0, "Blue Gate"), new CmdValue(CmdValueType.BOOL, "AVPG", 0.0, "Analog Video Pedestal Gate"), new CmdValue(CmdValueType.BOOL, "GAMC", 0.0, "Gamma Correction Gate"), new CmdValue(CmdValueType.BOOL, "RFLD", 0.0, "Repeat Field Gate"), new CmdValue(CmdValueType.BOOL, "PCPG", 0.0, "Pixel Clock Pulse Gate"), new CmdValue(CmdValueType.BOOL, "TSPG", 0.0, "Tri-Level Sync Pulse Gate"), new CmdValue(CmdValueType.BOOL, "LPFG", 0.0, true, ""), new CmdValue(CmdValueType.BOOL, "EQUF", 0.0, "Equalization Flatten Gate"), new CmdValue(CmdValueType.BOOL, "BALG", 0.0, "DC Balancing Gate"), new CmdValue(CmdValueType.BOOL, "PREG", 0.0, "Pre-emphasis Gate"), new CmdValue(CmdValueType.BOOL, "DADG", 1.0, "Digital Audio Down-mix Gate"), new CmdValue(CmdValueType.INT, "DVSP", 1.0, true, ""), new CmdValue(CmdValueType.INT, "HRES", 640.0, "Horizontal Active"), new CmdValue(CmdValueType.INT, "HTOT", 800.0, "Horizontal Total"), new CmdValue(CmdValueType.INT, "VRES", 480.0, "Vertical Active"), new CmdValue(CmdValueType.INT, "VTOT", 525.0, "Vertical Total"), new CmdValue(CmdValueType.INT, "HSPD", 16.0, "Horizontal Pulse Delay"), new CmdValue(CmdValueType.INT, "HSPW", 96.0, "Horizontal Pulse Width"), new CmdValue(CmdValueType.INT, "VSPD", 10.0, "Vertical Pulse Delay"), new CmdValue(CmdValueType.INT, "VSPW", 2.0, "Vertical Pulse Width"), new CmdValue(CmdValueType.INT, "EQUB", 0.0, "Equalizations Before"), new CmdValue(CmdValueType.INT, "EQUA", 0.0, "Equalizations After"), new CmdValue(CmdValueType.INT, "SCAN", 1.0, g_scanValues, "Scan Type"), new CmdValue(CmdValueType.INT, "USIZ", 1.0, g_usizeValues, "Unit Size"), new CmdValue(CmdValueType.INT, "AVST", 0.0, g_avstValues, "Analog Video Signal Type"), new CmdValue(CmdValueType.INT, "DVST", 10.0, g_dvstValues, "Digital Video Signal Type"), new CmdValue(CmdValueType.INT, "SSST", 1.0, g_ssstValues, "Select Sync Signal Type"), new CmdValue(CmdValueType.INT, "DSST", 1.0, g_dsstValues, "Digital Sync Separate Type"), new CmdValue(CmdValueType.INT, "DSCT", 2.0, g_dsctValues, "Digital Sync Composite Type"), new CmdValue(CmdValueType.INT, "ASCT", 2.0, g_asctValues, "Analog Sync Composite Type"), new CmdValue(CmdValueType.INT, "DCBM", 15.0, true, ""), new CmdValue(CmdValueType.INT, "DCEX", 14.0, true, ""), new CmdValue(CmdValueType.INT, "AVCM", 0.0, g_avcmValues, "Analog Video Calibration Mode"), new CmdValue(CmdValueType.INT, "AVCO", 0.0, g_avcoValues, "Analog Video Configuration"), new CmdValue(CmdValueType.INT, "AVCS", 0.0, g_avcsValues, "Analog Video Color Subcarrier Selection"), new CmdValue(CmdValueType.INT, "PELD", 0.0, g_peldValues, "Pixel Depth"), new CmdValue(CmdValueType.INT, "HVSA", 0.0, "Horizontal Vertical Sync Adjustment"), new CmdValue(CmdValueType.INT, "NLNK", 1.0, g_nlnkValues, "Number of Digital Links"), new CmdValue(CmdValueType.INT, "NBPC", 0.0, g_nbcpValues, "Number of Bits per Component"), new CmdValue(CmdValueType.INT, "CTLM", 0.0, true, ""), new CmdValue(CmdValueType.INT, "NCPP", 1.0, "Number of Clocks Per Pixel"), new CmdValue(CmdValueType.INT, "DVQM", 0.0, "Digital Video Quantization Mode"), new CmdValue(CmdValueType.INT, "HVPD", 0.0, "Horizontal Vertical Sync Pulse Delay"), new CmdValue(CmdValueType.INT, "DVSM", 0.0, g_dvsmValues, "Digital Video Sampling Mode"), new CmdValue(CmdValueType.INT, "DVPT", 1.0, g_dvptValues, "Digital Video Protocol Type"), new CmdValue(CmdValueType.INT, "DVIC", 1.0, "Digital Video Identification Code"), new CmdValue(CmdValueType.INT, "NBPA", 16.0, g_nbpaValues, "Number Bits per Audio Sample"), new CmdValue(CmdValueType.INT, "NDAS", 1.0, "Number Digital Audio Streams"), new CmdValue(CmdValueType.INT, "NDAC", 2.0, "Number Digital Audio Channels"), new CmdValue(CmdValueType.INT, "DAST", 1.0, g_dastValues, "Digital Audio Signal Type"), new CmdValue(CmdValueType.INT, "DASI", 1.0, g_dasiValues, "Digital Audio Signal Interface"), new CmdValue(CmdValueType.INT, "DAXA", 3.0, "Digital Audio Content Available"), new CmdValue(CmdValueType.INT, "DAXG", 3.0, "Digital Audio Content Gate"), new CmdValue(CmdValueType.INT, "DACA", 3.0, "Digital Audio Channels Available"), new CmdValue(CmdValueType.INT, "DACG", 3.0, "Digital Audio Channel Gate"), new CmdValue(CmdValueType.INT, "DALS", 0.0, "Digital Audio Level Shift"), new CmdValue(CmdValueType.INT, "SXEX", 0.0, "Signal-from-Embedded Aperture Map"), new CmdValue(CmdValueType.INT, "NPPP", 1.0, "Number Pixels per Pixel"), new CmdValue(CmdValueType.INT, "EXCX", 0.0, "Embedded-from-Content Aperture Map"), new CmdValue(CmdValueType.DOUBLE, "CXAR", 1.3333333, "Content Aspect Ratio"), new CmdValue(CmdValueType.DOUBLE, "SXAR", 1.3333333, "Signal Aspect Ratio"), new CmdValue(CmdValueType.DOUBLE, "EXAR", 1.3333333, "Extended Aspect Ratio"), new CmdValue(CmdValueType.INT, "XLBW", 0.0, "Left Border Width"), new CmdValue(CmdValueType.INT, "XRBW", 0.0, "Right Border Width"), new CmdValue(CmdValueType.INT, "XTBH", 0.0, "Top Border Width"), new CmdValue(CmdValueType.INT, "XBBH", 0.0, "Bottom Border Width")};

    public Format() {
        this.addValues();
    }

    public void setName(String string, boolean bl) {
        this.m_name = string;
        this.m_local = bl;
        if (bl) {
            this.m_fromIP = "";
        }
    }

    public boolean isLocal() {
        return this.m_local;
    }

    public String getName() {
        return this.m_name;
    }

    public void setFromIP(String string) {
        this.m_fromIP = string;
    }

    public String getFromIP() {
        return this.m_fromIP;
    }

    public int getInt(String string) {
        CmdValue cmdValue = this.m_valueMap.get(string);
        if (cmdValue != null) {
            return cmdValue.getInt();
        }
        MsgLog.error("INT param not found (internal error): " + string);
        return 0;
    }

    public double getDouble(String string) {
        CmdValue cmdValue = this.m_valueMap.get(string);
        if (cmdValue != null) {
            return cmdValue.getDouble();
        }
        MsgLog.error("DBL param not found (internal error): " + string);
        return 0.0;
    }

    public boolean getBool(String string) {
        CmdValue cmdValue = this.m_valueMap.get(string);
        if (cmdValue != null) {
            return cmdValue.getBool();
        }
        MsgLog.error("Bool param not found (internal error): " + string);
        return false;
    }

    public CmdValue getValue(String string) {
        return this.m_valueMap.get(string);
    }

    public Collection<CmdValue> getValues() {
        return this.m_valueMap.values();
    }

    public void addValue(CmdValue cmdValue) {
        cmdValue.setDerived(true);
        this.m_valueMap.put(cmdValue.getName(), cmdValue);
    }

    private void addValues() {
        for (CmdValue cmdValue : g_vals) {
            this.m_valueMap.put(cmdValue.getName(), cmdValue.clone());
        }
    }

    public static CmdValue getBaseValue(String string) {
        for (CmdValue cmdValue : g_vals) {
            if (!cmdValue.getName().equalsIgnoreCase(string)) continue;
            return cmdValue;
        }
        return null;
    }

    public static CmdValue[] getBaseValues() {
        return g_vals;
    }

    public boolean isModified() {
        for (CmdValue cmdValue : this.m_valueMap.values()) {
            if (cmdValue.isDerived() || !cmdValue.isModified()) continue;
            return true;
        }
        return false;
    }

    public void markUnmodified() {
        for (CmdValue cmdValue : this.m_valueMap.values()) {
            cmdValue.markUnmodified();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (CmdValue cmdValue : this.m_valueMap.values()) {
            stringBuffer.append(cmdValue.getName());
            stringBuffer.append(": ");
            stringBuffer.append(cmdValue.get());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

